#!/usr/bin/env python
#
############################################################################
#
# MODULE:    r.survey
# AUTHOR(S): Ivan Marchesini
# PURPOSE:   Define visible area from survey sites
#
# COPYRIGHT: (C) 2014 by Ivan Marchesini
#
#   This program is free software under the GNU General Public
#   License (>=v2). Read the file COPYING that comes with GRASS
#   for details.
#
#############################################################################

#%Module
#% description: map visible areas for field survey
#% keywords: visibility
#% keywords: survey
#%end
#%option G_OPT_V_POINTS
#% key: points
#% description: Name of input points map
#% required: yes
#%end
#%option G_OPT_R_DEM
#% key: dem
#% description: Name of input DEM map
#% required: yes
#%end
#%option G_OPT_R_OUTPUT
#% key: output
#% description: Name of output map
#% required: yes
#%end
#%option
#% key: maxdist
#% type: double
#% description: max visibility distance
#% required: yes
#% answer: 1000
#%end

import sys
#import os
#import atexit
import grass.script as grass
from grass.script import core as grasscore

def main():
    pnt = options['points']
    dem = options['dem']
    output = options['output']
    maxdist = float(options['maxdist'])
    
    grass.run_command("g.region", save='saved_region')
    #qui potrei mettere un controllo per generare aspect e slope solo dentro al range in cui si vuole fare la visibilita
    grass.run_command("r.slope.aspect", elevation=dem, slope="slope", aspect="aspect", overwrite=True, quiet=True)
    #calcolo l'azimuth
    grass.mapcalc("azimuth = (450-aspect) - int( (450-aspect) / 360) * 360", overwrite=True, quiet=True) 
    #calcolo componente verticale della normale al versante
    grass.mapcalc("c_dem = cos(slope)", overwrite=True, quiet=True)
    #calcolo componente verso nord della normale al versante
    grass.mapcalc("b_dem = sin(slope)*cos(azimuth)", overwrite=True, quiet=True)
    #calcolo componente verso est della normale al versante
    grass.mapcalc("a_dem = sin(slope)*sin(azimuth)", overwrite=True, quiet=True)    
    
    
    npnt=int(grass.vector_info_topo(pnt)["points"])
    ctg=grass.read_command("v.category", flags="g", input=pnt, option="print", type="point")
    ctg=ctg.split("\n")
    #print(ctg)
    ctg.pop(-1) #remove last empy element of the list
     
    
    grass.mapcalc("xxtemp = 0", overwrite=True, quiet=True)
    grass.mapcalc("xxtemp2 = 0", overwrite=True, quiet=True)
    grass.mapcalc("xxtemp3 = 0", overwrite=True, quiet=True)
    grass.mapcalc("xxtemp4 = 0", overwrite=True, quiet=True)
    
    #grass.mapcalc("xxview = null()", overwrite=True, quiet=True)
    #grass.mapcalc("verifica = null()", overwrite=True, quiet=True)
    k=0
    for i in ctg:
        k=k+1
        message = """
        --------------------------------------
        ----------- running line %s (cat = %s) of %s lines --
        --------------------------------------
        """
        grass.message(message % (k,i,npnt))
        grass.run_command("v.extract", input=pnt, output="pnt", cat=i, overwrite=True, quiet=True)
        #grass.run_command("v.extract", input=pnt, output="pnt"+str(i), cat=i, overwrite=True, quiet=True)
        coords=grass.read_command("v.to.db", flags="p", map="pnt", type="point", option="coor", separator="|", quiet=True)
        x=float(coords.split("|")[1])
        y=float(coords.split("|")[2])
        coords=str(x)+","+str(y)
        #print(coords)
        querydem=grass.read_command("r.what", coordinates=coords, map=dem)
        obselev=float(querydem.split("|")[3])
        #print(obselev)

        grass.run_command("g.region", vect="pnt")
        region = grasscore.region()
        E = region['e']
        W = region['w']
        N = region['n']
        S = region['s']
        #grass.run_command("g.region", flags="a", e=E+maxdist, w=W-maxdist, s=S-maxdist, n=N+maxdist)   
        grass.run_command("g.region", flags="a", e=E+maxdist, w=W-maxdist, s=S-maxdist, n=N+maxdist)   
        grass.run_command("r.viewshed", input=dem, output="view", coordinates=coords, max_dist=maxdist, memory=5000, overwrite=True, quiet=True)
        #qui c'e il g.region ma non sono sicuro sia il posto adatto, magari si potrebbe spostare a dopo
        grass.run_command("g.region", region="saved_region")
        #poiche' sotto i piedi dell'osservatore il valore che produce viewshed e' 180 (cosa che provoca problemi dopo) allora lo setto a 0.01
        grass.mapcalc("view = if(view==180,0.01,view)", overwrite=True, quiet=True)        
        grass.mapcalc("${A} = \
            if( y()>${py} && x()>${px}, atan((${px}-x())/(${py}-y())),  \
            if( y()<${py} && x()>${px}, 180+atan((${px}-x())/(${py}-y())),  \
            if( y()<${py} && x()<${px}, 180+atan((${px}-x())/(${py}-y())),  \
            if( y()>${py} && x()<${px}, 360+atan((${px}-x())/(${py}-y())))      )      )    )", A='angolo_vista',py=y, px=x, overwrite=True, quiet=True)
        grass.mapcalc("view90 = view - 90", overwrite=True, quiet=True)
        #calcolo componente verso l'alto della linea di vista        
        grass.mapcalc("c_view = sin(view90)", overwrite=True, quiet=True)
        #calcolo componente verso nord della linea di vista
        grass.mapcalc("b_view = cos(view90)*cos(angolo_vista)", overwrite=True, quiet=True)
        #calcolo componente verso est della linea di vista
        grass.mapcalc("a_view = cos(view90)*sin(angolo_vista)", overwrite=True, quiet=True)
        
        #posso calcolarmi anche la distanza in 3d di ogni punto dall'ossevatore
        grass.mapcalc("${D} = pow(pow(abs(y()-${py}),2)+pow(abs(x()-${px}),2)+pow(abs(${dtm}-(${obs}+1.75)),2),0.5)", D='distance', dtm=dem, obs=obselev, py=y, px=x, overwrite=True, quiet=True)

        

        #Posso fare la somma delle delle componenti dei versori della linea di vista e della normale al versante.  Per farlo devo prima calcolare la somma delle componenti
        #grass.mapcalc("sum_c = abs(c_dem + c_view)", overwrite=True, quiet=True)
        #grass.mapcalc("sum_b = abs(b_dem + b_view)", overwrite=True, quiet=True)
        #grass.mapcalc("sum_a = abs(a_dem + a_view)", overwrite=True, quiet=True)
        #e poi calcolare il versore        
        #Mi aspetto che se un pixel si trova esattamente di fronte all'osservatore i due versori sono 
        #opposti di segno e uguali in modulo e quindi si annullano (-1 e 1). Di conseguenza se vanno nello stesso senso la somma e' 2 o -2 
        #ma non si dovrebbe mai verificare perche' non dovrebbero vedersi
        #grass.mapcalc("versor = sqrt(sum_a^2+sum_b^2+sum_c^2)", overwrite=True, quiet=True)


        ###  QUESTO NON RICORDO COSA FOSSE E lO TENGO SOLO PER SICUREZZA PER ORA  grass.mapcalc("${A} = c_view*cos(angolo_vista)*c_dem*cos(azimuth) + c_view*sin(angolo_vista)*sin(azimuth)", A='survey_angle2' ,overwrite=True, quiet=True)

        #Tuttavia sono anche interessato a calcolare l'angolo tra i due vettori. 
        #posso farlo sfruttando il vettore somma appena calcolato
        #grass.mapcalc("${A} = acos(((versor)^2-2)/2)", A='survey_angle2' ,overwrite=True, quiet=True)
        
        #oppure posso farlo mediante il calcolo di prodotto scalare e norme dei vettori, ho verificato che il risultato e' lo stesso.
        #grass.mapcalc("prodottoscalare = a_view*a_dem+b_view*b_dem+c_view*c_dem", overwrite=True, quiet=True)
        #grass.mapcalc("prodottonorme = sqrt(a_view*a_view+b_view*b_view+c_view*c_view)*sqrt(a_dem*a_dem+b_dem*b_dem+c_dem*c_dem)", overwrite=True, quiet=True)
        #grass.mapcalc("angle = acos(prodottoscalare/prodottonorme)", overwrite=True, quiet=True)
        
        #In particolare il secondo metodo puo' essere combinato tutto assieme in un unico run di r.mapcalc, velocizzando i calcoli
        grass.mapcalc("angle = acos((a_view*a_dem+b_view*b_dem+c_view*c_dem)/(sqrt(a_view*a_view+b_view*b_view+c_view*c_view)*sqrt(a_dem*a_dem+b_dem*b_dem+c_dem*c_dem)))", overwrite=True, quiet=True)
        
        #posso calcolarmi una distanza riscalata (distanza / (-cos(angle))). Attenzione: tolgo i pixels in cui angle e' minore  di 91, altrimenti sbarella
        grass.mapcalc("dist_rescaled = if(angle>91,(distance/(-cos(angle))),null())",overwrite=True, quiet=True)
        
        #devo trasformare i nulli in zero in modo tale che poi possa fare il massimo, altrimenti i nulli mi rendono la mappa finale nulla
        grass.run_command("r.null", map='angle', null=0, quiet=True)
        #grass.run_command("r.null", map='dist_rescaled', null=0, quiet=True)
        #qui metto assieme le mappe che si generano pian piano dai vari punti analizzati
        #distanza riscalata
        grass.mapcalc("xxtemp4 = if(isnull(dist_rescaled),xxtemp4, if(xxtemp4 != 0,min(dist_rescaled,xxtemp4),dist_rescaled))",overwrite=True, quiet=True)
        #identificazione dei punti di vista con angolo maggiore (migiori)
        grass.mapcalc("xxtemp3 = if(angle==0,xxtemp3, if(angle<xxtemp,xxtemp3,${cat}) ) ", cat=i, overwrite=True, quiet=True)
        #numero dei punti di vista che vedono un certo pixel
        grass.mapcalc("xxtemp2 = if(angle==0,xxtemp2,xxtemp2+1)", overwrite=True, quiet=True)
        #miglior angolo di vista possibile tra tutti i  punti id vista
        grass.mapcalc("xxtemp = max(xxtemp,angle)", overwrite=True, quiet=True)
        #distanza
        
        

    #scrivo l'aoutput, premurandomi prima di mettere a nullo i valori 0 della mappa
    grass.run_command("r.null", map='xxtemp', setnull=0, quiet=True)
    grass.run_command("r.null", map='xxtemp2', setnull=0, quiet=True)
    grass.run_command("r.null", map='xxtemp3', setnull=0, quiet=True)
    grass.run_command("r.null", map='xxtemp4', setnull=0, quiet=True)
    grass.run_command("g.copy", rast=('xxtemp',output+'_viewangles'), quiet=True)
    grass.run_command("g.copy", rast=('xxtemp2',output+'_numberofviews'), quiet=True)
    grass.run_command("g.copy", rast=('xxtemp3',output+'_pointofviews'), quiet=True)
    grass.run_command("g.copy", rast=('xxtemp4',output+'_distance_rescaled'), quiet=True)
   

    grass.run_command("g.remove", type='vector', name="pnt", quiet=True)
    grass.run_command("g.remove", type='raster', name="xxtemp", quiet=True)
    grass.run_command("g.remove", type='raster', name="angolo_vista", quiet=True)    
    grass.run_command("g.remove", type='raster', name="slope", quiet=True)    
    grass.run_command("g.remove", type='raster', name="aspect", quiet=True)        
    grass.run_command("g.remove", type='raster', name="azimuth", quiet=True)    
    grass.run_command("g.remove", type='raster', name="c_dem", quiet=True)    
    grass.run_command("g.remove", type='raster', name="b_dem", quiet=True)    
    grass.run_command("g.remove", type='raster', name="a_dem", quiet=True)
    grass.run_command("g.remove", type='raster', name="view90", quiet=True)
    grass.run_command("g.remove", type='raster', name="c_view", quiet=True)
    grass.run_command("g.remove", type='raster', name="b_view", quiet=True)
    grass.run_command("g.remove", type='raster', name="a_view", quiet=True)
    #grass.run_command("g.remove", type='raster', name="sum_c", quiet=True)
    #grass.run_command("g.remove", type='raster', name="sum_b", quiet=True)
    #grass.run_command("g.remove", type='raster', name="sum_a", quiet=True)
    #grass.run_command("g.remove", type='raster', name="versor", quiet=True)    

    
if __name__ == "__main__":
    options, flags = grass.parser()
    #atexit.register(cleanup)
    sys.exit(main())
