CREATE DEFINER=`frims`@`%` FUNCTION `FN_NORMSDIST`(`INPUT_DATA` double)
	RETURNS double
	LANGUAGE SQL
	NOT DETERMINISTIC
	CONTAINS SQL
	SQL SECURITY DEFINER
	COMMENT ''
Begin

	SET @p = 0.3275911;
	SET @a1 = 0.254829592;
	SET @a2 = -0.284496736;
	SET @a3 = 1.421413741;
	SET @a4 = -1.453152027;
	SET @a5 = 1.061405429;
	SET @sn = 0;
	
	IF (INPUT_DATA < 0.0) THEN
		SET @sn = -1;
	ELSE
		SET @sn = 1;
	END IF;
	 
	SET @a = Abs(INPUT_DATA) / Sqrt(2.0);
	SET @t = 1.0 / (1.0 + @p * @a);
	SET @erf = 1.0 - (((((@a5 * @t + @a4) * @t) + @a3) * @t + @a2) * @t + @a1) * @t * Exp(-@a * @a);

 	return 0.5 * (1.0 + @sn * @erf);
End