package kr.co.gitech.frims.controller.earthquake;

import java.io.File;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import kr.co.gitech.frims.common.CustomConstants;
import kr.co.gitech.frims.common.message.MessageResolver;
import kr.co.gitech.frims.common.message.SystemCode;
import kr.co.gitech.frims.dto.common.BasicDTO;
import kr.co.gitech.frims.dto.earthquake.EarthQuakeAnalysisBuildObjectDTO;
import kr.co.gitech.frims.dto.earthquake.EarthQuakeAnalysisBuildRespomseObjectDTO;
import kr.co.gitech.frims.dto.earthquake.EarthQuakeAnalysisInputDataResponseDTO;
import kr.co.gitech.frims.dto.earthquake.EarthQuakeAnalysisRequestDTO;
import kr.co.gitech.frims.dto.earthquake.EarthQuakeDownloadJobRequestDTO;
import kr.co.gitech.frims.dto.earthquake.EarthQuakeStatisticsDTO;
import kr.co.gitech.frims.dto.earthquake.EarthQuakeStatisticsRequestDTO;
import kr.co.gitech.frims.dto.earthquake.EarthQuakeStatisticsResponseDTO;
import kr.co.gitech.frims.dto.earthquake.EarthQuakeStatisticsTypeDTO;
import kr.co.gitech.frims.dto.earthquake.EarthQuakeStatisticsTypeRequestDTO;
import kr.co.gitech.frims.dto.earthquake.EarthQuakeStatisticsTypeResponseDTO;
import kr.co.gitech.frims.dto.earthquake.EarthquakeAnalysisInputDataDTO;
import kr.co.gitech.frims.dto.login.UserSession;
import kr.co.gitech.frims.dto.search.SearchBuildCoordinateRequestDTO;
import kr.co.gitech.frims.service.earthquake.EarthQuakeAnalysisService;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

/**
 * Handles requests for the application home page.
 */
@Controller
@RequestMapping("/earthquake/analysis")
public class EarthQuakeAnalysisController {
	
	private static final Logger logger = LoggerFactory.getLogger(EarthQuakeAnalysisController.class);
	
	@Autowired
	private EarthQuakeAnalysisService earthQuakeAnalysisService;
	
	/**
	 * 지진 분석 목록 페이지
	 * @param headerMap
	 * @param request
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "")
	public ModelAndView list_view(@RequestHeader HashMap<String, Object> headerMap ,HttpServletRequest request) throws Exception {
		return new ModelAndView("/earthquake/list");
	}	
	
	/**
	 * 지진 보험로 분석 목록
	 * @param headerMap
	 * @param earthQuakeAnalysisRequestDTO
	 * @param request
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/list")
	public ModelAndView list(ModelMap model,@RequestHeader HashMap<String, Object> headerMap,HttpServletRequest request) throws Exception {
		
		ModelAndView mav = new ModelAndView();
		
		try {
			
			List<EarthquakeAnalysisInputDataDTO> earthQuakeAnalysisDataList  = earthQuakeAnalysisService.getEarchQuakAnalysisInputDataList();
			
			EarthQuakeAnalysisInputDataResponseDTO  earthQuakeAnalysisInputDataResponseDTO = new EarthQuakeAnalysisInputDataResponseDTO();
			earthQuakeAnalysisInputDataResponseDTO.setEarthQuakeAnalysisDataList(earthQuakeAnalysisDataList);
			
			model.clear();
			mav.addObject("data", earthQuakeAnalysisInputDataResponseDTO);
			
		} catch ( Exception e ) {
			logger.debug("headerMap : " + headerMap);
			throw e; 
		}
		
		mav.setViewName("jsonView");
		return mav;
	}
	
	/**
	 * 지진 분석 목록 페이지
	 * @param headerMap
	 * @param request
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/select")
	public ModelAndView select(@RequestHeader HashMap<String, Object> headerMap ,HttpServletRequest request) throws Exception {
		return new ModelAndView("/earthquake/select");
	}
	
	/**
	 * 지진 보험로 분석 요청
	 * @param headerMap
	 * @param earthQuakeAnalysisRequestDTO
	 * @param request
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/request")
	public ModelAndView request(ModelMap model, @RequestHeader HashMap<String, Object> headerMap, @ModelAttribute EarthQuakeAnalysisRequestDTO earthQuakeAnalysisRequestDTO,HttpServletRequest request) throws Exception {
		
		ModelAndView mav = new ModelAndView();
		
		try {
			UserSession aSession = (UserSession)(request.getSession(false)).getAttribute(CustomConstants.SESSION);
			//분석 등록자 ID 셋팅
			earthQuakeAnalysisRequestDTO.setReg_id(aSession.getUser().getUser_id());
			
			earthQuakeAnalysisService.analysis(earthQuakeAnalysisRequestDTO);
			BasicDTO basicDTO = new BasicDTO();
			model.clear();
			mav.addObject("data", basicDTO);
			
		} catch ( Exception e ) {
			logger.debug("headerMap : " + headerMap);
			logger.debug("params : " + earthQuakeAnalysisRequestDTO.toString());
			throw e; 
		}
		
		mav.setViewName("jsonView");
		return mav;
	}
	
	/**
	 * 지진 분석 상세 페이지
	 * @param headerMap
	 * @param request
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/detail")
	public ModelAndView detail(ModelMap model, @RequestHeader HashMap<String, Object> headerMap ,HttpServletRequest request) throws Exception {
		
		ModelAndView mav = new ModelAndView();
		
		try {
			
			EarthquakeAnalysisInputDataDTO earthquakeAnalysisInputDataDTO = earthQuakeAnalysisService.latestAnalysisInfo();
			
			model.clear();
			mav.addObject("data", earthquakeAnalysisInputDataDTO);

		} catch ( Exception e ) {
			logger.debug("headerMap : " + headerMap);
			throw e; 
		}
		mav.setViewName("/earthquake/detail");
		return mav;
	}	
	
	/**
	 * 좌푤르 이용한 건물 데이터
	 * @param headerMap
	 * @param searchBuildCoordinateRequestDTO
	 * @param request
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/build/coordinate")
	public ModelAndView coordinate(ModelMap model,@RequestHeader HashMap<String, Object> headerMap, @ModelAttribute SearchBuildCoordinateRequestDTO searchBuildCoordinateRequestDTO,HttpServletRequest request) throws Exception {
		
		ModelAndView mav = new ModelAndView();
		
		try {
			
			EarthQuakeAnalysisBuildObjectDTO earthQuakeAnalysisBuildObjectDTO = earthQuakeAnalysisService.coordinate(searchBuildCoordinateRequestDTO);
			EarthQuakeAnalysisBuildRespomseObjectDTO earthQuakeAnalysisBuildRespomseObjectDTO = new EarthQuakeAnalysisBuildRespomseObjectDTO();
			earthQuakeAnalysisBuildRespomseObjectDTO.setEarthQuakeAnalysisBuildObjectDTO(earthQuakeAnalysisBuildObjectDTO);
			
			model.clear();
			mav.addObject("data", earthQuakeAnalysisBuildRespomseObjectDTO);

		} catch ( Exception e ) {
			logger.debug("headerMap : " + headerMap);
			logger.debug("params : " + searchBuildCoordinateRequestDTO.toString());
			throw e; 
		}
		
		mav.setViewName("jsonView");
		return mav;
	}
	
	/**
	 * 지진 손상률 통계
	 * @param headerMap
	 * @param earthQuakeStatisticsRequestDTO
	 * @param request
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/statistics")
	public ModelAndView statistics(ModelMap model,@RequestHeader HashMap<String, Object> headerMap, @ModelAttribute EarthQuakeStatisticsRequestDTO earthQuakeStatisticsRequestDTO,HttpServletRequest request) throws Exception {
		
		ModelAndView mav = new ModelAndView();
		
		try {
			
			switch (earthQuakeStatisticsRequestDTO.getType()) {
				case 0:
					earthQuakeStatisticsRequestDTO.setColnm("TOTAL_ASSETS");
					break;
				case 1:
					earthQuakeStatisticsRequestDTO.setColnm("STRUCT_CD");
					break;
				case 2:
					earthQuakeStatisticsRequestDTO.setColnm("MAIN_USE_CD");
					break; 
				case 3:
					earthQuakeStatisticsRequestDTO.setColnm("GROUND_NUM");
					break;
				case 4:
					earthQuakeStatisticsRequestDTO.setColnm("YEAR_CD");
					break;
				case 5:
					earthQuakeStatisticsRequestDTO.setColnm("SUM_TOTAL_STUCT_ASSETS + SUM_TOTAL_ETC_ASSETS");
					break;
				case 6:
					earthQuakeStatisticsRequestDTO.setColnm("SUM_TOTAL_STUCT_ASSETS");
					break;
				case 7:
					earthQuakeStatisticsRequestDTO.setColnm("SUM_TOTAL_ETC_ASSETS");
					break;
				case 8:
					earthQuakeStatisticsRequestDTO.setColnm("TOTAL_AVG_RATE");
					break;
				case 9:
					earthQuakeStatisticsRequestDTO.setColnm("STRUCT_AVG_RATE");
					break;
				case 10:
					earthQuakeStatisticsRequestDTO.setColnm("ETC_AVG_RATE");
					break;
			}
			

			EarthQuakeStatisticsDTO earthQuakeStatisticsDTO = earthQuakeAnalysisService.statistics(earthQuakeStatisticsRequestDTO);

			EarthQuakeStatisticsResponseDTO earthQuakeStatisticsResponseDTO = new EarthQuakeStatisticsResponseDTO();
			earthQuakeStatisticsResponseDTO.setEarthQuakeStatisticsDTO(earthQuakeStatisticsDTO);
			
			model.clear();
			mav.addObject("data", earthQuakeStatisticsResponseDTO);

		} catch ( Exception e ) {
			logger.debug("headerMap : " + headerMap);
			logger.debug("params : " + earthQuakeStatisticsRequestDTO.toString());
			throw e; 
		}
		
		mav.setViewName("jsonView");
		return mav;
	}

	/**
	 * 지진 손상률 통계(구분별 통계
	 * @param headerMap
	 * @param earthQuakeStatisticsRequestDTO
	 * @param request
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/statistics/type")
	public ModelAndView statisticsType(ModelMap model,@RequestHeader HashMap<String, Object> headerMap
			, @ModelAttribute EarthQuakeStatisticsTypeRequestDTO earthQuakeStatisticsTypeRequestDTO,HttpServletRequest request) throws Exception {
		
		ModelAndView mav = new ModelAndView();

		try {

			List<EarthQuakeStatisticsTypeDTO> earthQuakeStatisticsTypeDTOList = earthQuakeAnalysisService.statisticsType(earthQuakeStatisticsTypeRequestDTO);

			EarthQuakeStatisticsTypeResponseDTO earthQuakeStatisticsTypeResponseDTO = new EarthQuakeStatisticsTypeResponseDTO();
			earthQuakeStatisticsTypeResponseDTO.setEarthQuakeStatisticsTypeDTOList(earthQuakeStatisticsTypeDTOList);
			
			model.clear();
			mav.addObject("data", earthQuakeStatisticsTypeResponseDTO);

		} catch ( Exception e ) {
			logger.debug("headerMap : " + headerMap);
			logger.debug("params : " + earthQuakeStatisticsTypeRequestDTO.toString());
			throw e; 
		}
		
		mav.setViewName("jsonView");
		return mav;
	}
	
	/**
	 * 다운로드 작업 요청
	 * @param model
	 * @param headerMap
	 * @param request
	 * @param earthQuakeDownloadJobRequestDTO
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/download/job")
	public ModelAndView down_job(ModelMap model,@RequestHeader HashMap<String, Object> headerMap ,HttpServletRequest request
			 , @ModelAttribute EarthQuakeDownloadJobRequestDTO earthQuakeDownloadJobRequestDTO) throws Exception {
		
		ModelAndView mav = null;
		
		try {
			
			if(earthQuakeDownloadJobRequestDTO.getDown_state() == CustomConstants.DOWN_JOB_C){
				String file_nm = String.format(CustomConstants.DOWN_FILE_NM, earthQuakeDownloadJobRequestDTO.getSeq());
				File file = new File(MessageResolver.getMessage(SystemCode.GEOSERVER_SHAPE_DOWN_FOLDER.message())+file_nm+".zip");
				mav = new ModelAndView("fileDownloadView");
				mav.addObject("file", file);
				mav.addObject("fileName", file_nm);
			}else{
				BasicDTO basicDTO = earthQuakeAnalysisService.downloadJob(earthQuakeDownloadJobRequestDTO);
				model.clear();
				mav = new ModelAndView();
				mav.addObject("data", basicDTO);
				mav.setViewName("jsonView");
			}

		} catch ( Exception e ) {
			logger.debug("headerMap : " + headerMap);
			logger.debug("params : " + earthQuakeDownloadJobRequestDTO.toString());
			throw e; 
		}
		
		return mav;
	}
	
}