CREATE DEFINER=`frims`@`%` EVENT `EVENT_EARTHQUAKE_ASSETS_ANALYSIS`
	ON SCHEDULE
		EVERY 1 MINUTE STARTS '2017-07-10 15:16:47'
	ON COMPLETION NOT PRESERVE
	ENABLE
	COMMENT ''
	DO BEGIN			
			
		SELECT @S_CNT := COUNT(*) FROM earthquake_assets_analysis WHERE STATE = 'S' ORDER BY REG_DT DESC LIMIT 1;
		
		IF @S_CNT <= 0 THEN
					
			SELECT @I_CNT := COUNT(*) FROM earthquake_assets_analysis WHERE STATE = 'I';	
			
			IF @I_CNT > 0 THEN
			
				SELECT  
					@SEQ := SEQ
					, @LAT := LAT
					, @LON := LON
					, @D := D
					, @M := M
					, @C0 := C0
					, @C1 := C1
					, @C2 := C2 
					, @C3 := C3
					, @FA0 := FA0
					, @FA1 := FA1
					, @FA2 := FA2
					, @FV0 := FV0
					, @FV1 := FV1
					, @FV2 := FV2
				FROM earthquake_assets_analysis WHERE STATE = 'I' ORDER BY REG_DT DESC LIMIT 1;
				
				UPDATE earthquake_assets_analysis SET STATE='S' , START_DT = NOW() WHERE SEQ = @SEQ;
				COMMIT;
				
				UPDATE 
					SEOUL_TL_SPBD_BULD TB1 
					INNER JOIN PARAM_CAPACITY_CURVE TB3 ON TB1.FINAL_CD = TB3.EQBLDGTYPE AND TB1.FUNCTION_CD = TB3.DESIGNLEVEL 
					INNER JOIN param_fragility_curve_copy TB4 ON TB1.FINAL_CD = TB4.EQ_BLDG_TYPE AND TB1.FUNCTION_CD = TB4.DESIGN_LEVEL 
					INNER JOIN PARAM_FINANCE TB5 ON TB1.MAIN_USE_CD = TB5.MAIN_USE_CD 
				set 
					TB1.H = ( @H := (6371*acos(cos(radians(@LAT))*cos(radians(CT_LAT))*cos(radians(CT_LON)-radians(@LON))+sin(radians(@LAT))*sin(radians(CT_LAT)))) )
					, TB1.R = ( @R := (sqrt(pow(@D, 2) + pow(@H, 2))) )
					, TB1.PGA = ( @PGA := (((exp(@C0 +@C1*@M+@C2*log(@R)+@C3*@R))/9.8)/100) )
					, TB1.FA = ( @FA := (if(@PGA < 0.25,@FA0,if(@PGA <= 0.625, @FA1,@FA2))) )
					, TB1.FV = ( @FV := (if(@PGA < 0.25,@FV0,if(@PGA <= 0.625, @FV1,@FV2))) )
					, TB1.SDS = ( @SDS :=  @PGA*2.5*@FA)
					, TB1.SD1 = ( @SD1 := (@PGA*@FV) )
					, TB1.T0 = ( @T0 := 0.06 )
					, TB1.TS = ( @TS := 0.2 )
					, TB1.TVD = ( @TVD := 3 )
					
					
					
					, TB1.SD = ( @SD := 
						(
							IF(
								((9.8 * @SDS * POW(@T0, 2)) <= (-(@SDS*FC_C)/(@SDS*FC_B-FC_A)) AND (9.8 * @SDS * POW(@TS, 2)) >= (-(@SDS*FC_C)/(@SDS*FC_B-FC_A)))
								, (-(@SDS*FC_C)/(@SDS*FC_B-FC_A))
								-- , (7*sqrt(127)*@SD1*sqrt(400000*FC_A*FC_C+6223*POW(@SD1,2)*POW(FC_B,2))+6223*POW(@SD1,2)*FC_B)/(200000*FC_A)
								, (7*@SD1*sqrt(80*FC_A*FC_C+49*POW(@SD1,2)*POW(FC_B,2))+49*POW(@SD1,2)*FC_B)/(40*FC_A)
							) 	
						) * 0.0254
					)
					
					, TB1.SA = ( @SA := @PGA )
					
					
					
					
					, TB1.COMPLETE_PROBABILITY_STR	= ( @COMPLETE_PROBABILITY_STR := (FN_PROBABILITY(@SD / 0.0254, TB4.COMPLETE_MEDIAN_STR, TB4.COMPLETE_BETA_STR)) )
					, TB1.EXTENSIVE_PROBABILITY_STR	= ( @EXTENSIVE_PROBABILITY_STR := (FN_PROBABILITY(@SD / 0.0254, TB4.EXTENSIVE_MEDIAN_STR, TB4.EXTENSIVE_BETA_STR) - @COMPLETE_PROBABILITY_STR) )
					, TB1.MODERATE_PROBABILITY_STR	= ( @MODERATE_PROBABILITY_STR := (FN_PROBABILITY(@SD / 0.0254, TB4.MODERATE_MEDIAN_STR, TB4.MODERATE_BETA_STR) - (@COMPLETE_PROBABILITY_STR + @EXTENSIVE_PROBABILITY_STR) ) )
					, TB1.SLIGHT_PROBABILITY_STR		= ( @SLIGHT_PROBABILITY_STR := (FN_PROBABILITY(@SD / 0.0254, TB4.SLIGHT_MEDIAN_STR, TB4.SLIGHT_BETA_STR) - (@COMPLETE_PROBABILITY_STR + @EXTENSIVE_PROBABILITY_STR + @MODERATE_PROBABILITY_STR) ) )
					, TB1.SUM_PROBABILITY_STR			= ( @SUM_PROBABILITY_STR := (@SLIGHT_PROBABILITY_STR+@MODERATE_PROBABILITY_STR+@EXTENSIVE_PROBABILITY_STR+@COMPLETE_PROBABILITY_STR) )
					
					
					, TB1.COMPLETE_PROBABILITY_NSD	= ( @COMPLETE_PROBABILITY_NSD := (FN_PROBABILITY(@SD / 0.0254, TB4.COMPLETE_MEDIAN_NSD, TB4.COMPLETE_BETA_NSD)) )
					, TB1.EXTENSIVE_PROBABILITY_NSD	= ( @EXTENSIVE_PROBABILITY_NSD := (FN_PROBABILITY(@SD / 0.0254, TB4.EXTENSIVE_MEDIAN_NSD, TB4.EXTENSIVE_BETA_NSD) - @COMPLETE_PROBABILITY_NSD) )
					, TB1.MODERATE_PROBABILITY_NSD	= ( @MODERATE_PROBABILITY_NSD := (FN_PROBABILITY(@SD / 0.0254, TB4.MODERATE_MEDIAN_NSD , TB4.MODERATE_BETA_NSD) - (@COMPLETE_PROBABILITY_NSD + @EXTENSIVE_PROBABILITY_NSD)) )
					, TB1.SLIGHT_PROBABILITY_NSD		= ( @SLIGHT_PROBABILITY_NSD := (FN_PROBABILITY(@SD / 0.0254, TB4.SLIGHT_MEDIAN_NSD, TB4.SLIGHT_BETA_NSD) - (@COMPLETE_PROBABILITY_NSD + @EXTENSIVE_PROBABILITY_NSD + @MODERATE_PROBABILITY_NSD)) )
					, TB1.SUM_PROBABILITY_NSD			= ( @SUM_PROBABILITY_NSD := (@SLIGHT_PROBABILITY_NSD+@MODERATE_PROBABILITY_NSD+@EXTENSIVE_PROBABILITY_NSD+@COMPLETE_PROBABILITY_NSD) )
					
					, TB1.COMPLETE_PROBABILITY_NSA	= ( @COMPLETE_PROBABILITY_NSA := (FN_PROBABILITY(@SA, TB4.COMPLETE_MEDIAN_NSA, TB4.COMPLETE_BETA_NSA)) )
					, TB1.EXTENSIVE_PROBABILITY_NSA	= ( @EXTENSIVE_PROBABILITY_NSA := (FN_PROBABILITY(@SA, TB4.EXTENSIVE_MEDIAN_NSA, TB4.EXTENSIVE_BETA_NSA) - @COMPLETE_PROBABILITY_NSA) )
					, TB1.MODERATE_PROBABILITY_NSA	= ( @MODERATE_PROBABILITY_NSA := (FN_PROBABILITY(@SA, TB4.MODERATE_MEDIAN_NSA , TB4.MODERATE_BETA_NSA) - (@COMPLETE_PROBABILITY_NSA + @EXTENSIVE_PROBABILITY_NSA)) )
					, TB1.SLIGHT_PROBABILITY_NSA		= ( @SLIGHT_PROBABILITY_NSA := (FN_PROBABILITY(@SA, TB4.SLIGHT_MEDIAN_NSA, TB4.SLIGHT_BETA_NSA) - (@COMPLETE_PROBABILITY_NSA + @EXTENSIVE_PROBABILITY_NSA + @MODERATE_PROBABILITY_NSA)) )
					, TB1.SUM_PROBABILITY_NSA			= ( @SUM_PROBABILITY_NSA := (@SLIGHT_PROBABILITY_NSA+@MODERATE_PROBABILITY_NSA+@EXTENSIVE_PROBABILITY_NSA+@COMPLETE_PROBABILITY_NSA) )
									
					, TB1.COMPLETE_PROBABILITY_CNT	= ( @COMPLETE_PROBABILITY_CNT := (FN_PROBABILITY(@SA, TB4.COMPLETE_MEDIAN_CNT, TB4.COMPLETE_BETA_CNT)) )
					, TB1.EXTENSIVE_PROBABILITY_CNT	= ( @EXTENSIVE_PROBABILITY_CNT := (FN_PROBABILITY(@SA, TB4.EXTENSIVE_MEDIAN_CNT, TB4.EXTENSIVE_BETA_CNT) - @COMPLETE_PROBABILITY_CNT) )
					, TB1.MODERATE_PROBABILITY_CNT	= ( @MODERATE_PROBABILITY_CNT := (FN_PROBABILITY(@SA, TB4.MODERATE_MEDIAN_CNT , TB4.MODERATE_BETA_CNT) - (@COMPLETE_PROBABILITY_CNT + @EXTENSIVE_PROBABILITY_CNT)) )
					, TB1.SLIGHT_PROBABILITY_CNT		= ( @SLIGHT_PROBABILITY_CNT := (FN_PROBABILITY(@SA, TB4.SLIGHT_MEDIAN_CNT, TB4.SLIGHT_BETA_CNT) - (@COMPLETE_PROBABILITY_CNT + @EXTENSIVE_PROBABILITY_CNT + @MODERATE_PROBABILITY_CNT)) )
					, TB1.SUM_PROBABILITY_CNT			= ( @SUM_PROBABILITY_CNT := (@SLIGHT_PROBABILITY_CNT+@MODERATE_PROBABILITY_CNT+@EXTENSIVE_PROBABILITY_CNT+@COMPLETE_PROBABILITY_CNT) )
															
					, TB1.TOTAL_STRUCT_ASSETS = ( @TOTAL_STRUCT_ASSETS := (TB1.TOTALAREA * TB5.STRUCT_ASSETS) )
					, TB1.ETC_STRUCT_ASSETS	= ( @ETC_STRUCT_ASSETS := (TB1.TOTALAREA * TB5.ETC_ASSETS) )
					, TB1.TOTAL_ASSETS	= ( @TOTAL_ASSETS := @ETC_STRUCT_ASSETS + @TOTAL_STRUCT_ASSETS)
					
					
					, TB1.SLIGHT_ASSETS_NSA = ( @SLIGHT_ASSETS_NSA := (@TOTAL_STRUCT_ASSETS*(TB5.SLIGHT_REPAIR_NSA/100)*(@SLIGHT_PROBABILITY_NSA/100)) )
					, TB1.MODERATE_ASSETS_NSA = ( @MODERATE_ASSETS_NSA := (@TOTAL_STRUCT_ASSETS*(TB5.MOD_REPAIR_NSA/100)*(@MODERATE_PROBABILITY_NSA/100)) )
					, TB1.EXTENSIVE_ASSETS_NSA = ( @EXTENSIVE_ASSETS_NSA := (@TOTAL_STRUCT_ASSETS*(TB5.EXT_REPAIR_NSA/100)*(@EXTENSIVE_PROBABILITY_NSA/100)) )
					, TB1.COMPLETE_ASSETS_NSA = ( @COMPLETE_ASSETS_NSA := (@TOTAL_STRUCT_ASSETS*(TB5.CMP_REPAIR_NSA/100)*(@COMPLETE_PROBABILITY_NSA/100)) )
					
					, TB1.SLIGHT_ASSETS_NSD = ( @SLIGHT_ASSETS_NSD := (@TOTAL_STRUCT_ASSETS*(TB5.SLIGHT_REPAIR_NSD/100)*(@SLIGHT_PROBABILITY_NSD/100)) )
					, TB1.MODERATE_ASSETS_NSD = ( @MODERATE_ASSETS_NSD := (@TOTAL_STRUCT_ASSETS*(TB5.MOD_REPAIR_NSD/100)*(@MODERATE_PROBABILITY_NSD/100)) )
					, TB1.EXTENSIVE_ASSETS_NSD = ( @EXTENSIVE_ASSETS_NSD := (@TOTAL_STRUCT_ASSETS*(TB5.EXT_REPAIR_NSD/100)*(@EXTENSIVE_PROBABILITY_NSD/100)) )
					, TB1.COMPLETE_ASSETS_NSD = ( @COMPLETE_ASSETS_NSD := (@TOTAL_STRUCT_ASSETS*(TB5.CMP_REPAIR_NSD/100)*(@COMPLETE_PROBABILITY_NSD/100)) )
						
					, TB1.SLIGHT_ASSETS_STR = ( @SLIGHT_ASSETS_STR := (@TOTAL_STRUCT_ASSETS*(TB5.SLIGHT_REPAIR_STR/100)*(@SLIGHT_PROBABILITY_STR/100)) )
					, TB1.MODERATE_ASSETS_STR = ( @MODERATE_ASSETS_STR := (@TOTAL_STRUCT_ASSETS*(TB5.MOD_REPAIR_STR/100)*(@MODERATE_PROBABILITY_STR/100)) )
					, TB1.EXTENSIVE_ASSETS_STR = ( @EXTENSIVE_ASSETS_STR := (@TOTAL_STRUCT_ASSETS*(TB5.EXT_REPAIR_STR/100)*(@EXTENSIVE_PROBABILITY_STR/100)) )
					, TB1.COMPLETE_ASSETS_STR = ( @COMPLETE_ASSETS_STR := (@TOTAL_STRUCT_ASSETS*(TB5.CMP_REPAIR_STR/100)*(@COMPLETE_PROBABILITY_STR/100)) )
				
				
					, TB1.SLIGHT_ASSETS_CNT = ( @SLIGHT_ASSETS_CNT := (@ETC_STRUCT_ASSETS*(TB5.SLIGHT_REPAIR_CNT/100)*(@SLIGHT_PROBABILITY_CNT/100)) )
					, TB1.MODERATE_ASSETS_CNT = ( @MODERATE_ASSETS_CNT := (@ETC_STRUCT_ASSETS*(TB5.MOD_REPAIR_CNT/100)*(@MODERATE_PROBABILITY_CNT/100)) )
					, TB1.EXTENSIVE_ASSETS_CNT = ( @EXTENSIVE_ASSETS_CNT := (@ETC_STRUCT_ASSETS*(TB5.EXT_REPAIR_CNT/100)*(@EXTENSIVE_PROBABILITY_CNT/100)) )
					, TB1.COMPLETE_ASSETS_CNT = ( @COMPLETE_ASSETS_CNT := (@ETC_STRUCT_ASSETS*(TB5.CMP_REPAIR_CNT/100)*(@COMPLETE_PROBABILITY_CNT/100)) )
					
					, TB1.SUM_TOTAL_STUCT_ASSETS = ( @SUM_TOTAL_STUCT_ASSETS := (
					@SLIGHT_ASSETS_NSA+@MODERATE_ASSETS_NSA+@EXTENSIVE_ASSETS_NSA+@COMPLETE_ASSETS_NSA
					+@SLIGHT_ASSETS_NSD+@MODERATE_ASSETS_NSD+@EXTENSIVE_ASSETS_NSD+@COMPLETE_ASSETS_NSD
					+@SLIGHT_ASSETS_STR+@MODERATE_ASSETS_STR+@EXTENSIVE_ASSETS_STR+@COMPLETE_ASSETS_STR) )
					
					, TB1.SUM_TOTAL_ETC_ASSETS = ( @SUM_TOTAL_ETC_ASSETS := (@SLIGHT_ASSETS_CNT+@MODERATE_ASSETS_CNT+@EXTENSIVE_ASSETS_CNT+@COMPLETE_ASSETS_CNT) )
					
					, TB1.STRUCT_AVG_RATE = ( @STRUCT_AVG_RATE := @SUM_TOTAL_STUCT_ASSETS / @TOTAL_STRUCT_ASSETS * 100 )	
					, TB1.ETC_AVG_RATE = ( @ETC_AVG_RATE := @SUM_TOTAL_ETC_ASSETS / @ETC_STRUCT_ASSETS * 100 )	
					, TB1.TOTAL_AVG_RATE = ( @TOTAL_AVG_RATE := (@SUM_TOTAL_STUCT_ASSETS+@SUM_TOTAL_ETC_ASSETS) / @TOTAL_ASSETS * 100 )
										
					-- , TB1.SLIGHT_REPAIR_TIME_NSA = ( @SLIGHT_REPAIR_TIME_NSA := (TB5.SLIGHT_REPAIR_TIME * @SLIGHT_PROBABILITY_NSA) )
					-- , TB1.MODERATE_REPAIR_TIME_NSA = ( @MODERATE_REPAIR_TIME_NSA := (TB5.MOD_REPAIR_TIME * @MODERATE_PROBABILITY_NSA) )
					-- , TB1.EXTENSIVE_REPAIR_TIME_NSA = ( @EXTENSIVE_REPAIR_TIME_NSA := (TB5.EXT_REPAIR_TIME * @EXTENSIVE_PROBABILITY_NSA) )
					-- , TB1.COMPLETE_REPAIR_TIME_NSA = ( @COMPLETE_REPAIR_TIME_NSA := (TB5.CMP_REPAIR_TIME * @COMPLETE_PROBABILITY_NSA) )
					
					-- , TB1.SLIGHT_REPAIR_TIME_NSD = ( @SLIGHT_REPAIR_TIME_NSD := (TB5.SLIGHT_REPAIR_TIME * @SLIGHT_PROBABILITY_NSD) )
					-- , TB1.MODERATE_REPAIR_TIME_NSD = ( @MODERATE_REPAIR_TIME_NSD := (TB5.MOD_REPAIR_TIME * @MODERATE_PROBABILITY_NSD) )
					-- , TB1.EXTENSIVE_REPAIR_TIME_NSD = ( @EXTENSIVE_REPAIR_TIME_NSD := (TB5.EXT_REPAIR_TIME * @EXTENSIVE_PROBABILITY_NSD) )
					-- , TB1.COMPLETE_REPAIR_TIME_NSD = ( @COMPLETE_REPAIR_TIME_NSD := (TB5.CMP_REPAIR_TIME * @COMPLETE_PROBABILITY_NSD) )
					
					, TB1.SLIGHT_REPAIR_TIME_STR = ( @SLIGHT_REPAIR_TIME_STR := (TB5.SLIGHT_REPAIR_TIME * @SLIGHT_PROBABILITY_STR) )
					, TB1.MODERATE_REPAIR_TIME_STR  = ( @MODERATE_REPAIR_TIME_STR := (TB5.MOD_REPAIR_TIME * @MODERATE_PROBABILITY_STR) )
					, TB1.EXTENSIVE_REPAIR_TIME_STR = ( @EXTENSIVE_REPAIR_TIME_STR := (TB5.EXT_REPAIR_TIME * @EXTENSIVE_PROBABILITY_STR) )
					, TB1.COMPLETE_REPAIR_TIME_STR = ( @COMPLETE_REPAIR_TIME_STR := (TB5.CMP_REPAIR_TIME * @COMPLETE_PROBABILITY_STR) )
					
					, TB1.ESTIMATE_REPAIR_TIME = ( @ESTIMATE_REPAIR_TIME := (@SLIGHT_REPAIR_TIME_STR+@MODERATE_REPAIR_TIME_STR+@EXTENSIVE_REPAIR_TIME_STR+@COMPLETE_REPAIR_TIME_STR) )
					
					-- , TB1.SLIGHT_RECOVERY_TIME_NSA = ( @SLIGHT_RECOVERY_TIME_NSA := (TB5.SLIGHT_RECOVERY_TIME * @SLIGHT_PROBABILITY_NSA) ) 
					-- , TB1.MODERATE_RECOVERY_TIME_NSA = ( @MODERATE_RECOVERY_TIME_NSA := (TB5.MOD_RECOVERY_TIME * @MODERATE_PROBABILITY_NSA) )
					-- , TB1.EXTENSIVE_RECOVERY_TIME_NSA = ( @EXTENSIVE_RECOVERY_TIME_NSA := (TB5.EXT_RECOVERY_TIME * @EXTENSIVE_PROBABILITY_NSA) )
					-- , TB1.COMPLETE_RECOVERY_TIME_NSA = ( @COMPLETE_RECOVERY_TIME_NSA := (TB5.CMP_RECOVERY_TIME * @COMPLETE_PROBABILITY_NSA) )
					
					-- , TB1.SLIGHT_RECOVERY_TIME_NSD = ( @SLIGHT_RECOVERY_TIME_NSD := (TB5.SLIGHT_RECOVERY_TIME * @SLIGHT_PROBABILITY_NSD) )
					-- , TB1.MODERATE_RECOVERY_TIME_NSD = ( @MODERATE_RECOVERY_TIME_NSD := (TB5.MOD_RECOVERY_TIME * @MODERATE_PROBABILITY_NSD) )
					-- , TB1.EXTENSIVE_RECOVERY_TIME_NSD = ( @EXTENSIVE_RECOVERY_TIME_NSD := (TB5.EXT_RECOVERY_TIME * @EXTENSIVE_PROBABILITY_NSD) )
					-- , TB1.COMPLETE_RECOVERY_TIME_NSD = ( @COMPLETE_RECOVERY_TIME_NSD := (TB5.CMP_RECOVERY_TIME * @COMPLETE_PROBABILITY_NSD) )
					
					, TB1.SLIGHT_RECOVERY_TIME_STR = ( @SLIGHT_RECOVERY_TIME_STR := (TB5.SLIGHT_RECOVERY_TIME * @SLIGHT_PROBABILITY_STR) )
					, TB1.MODERATE_RECOVERY_TIME_STR = ( @MODERATE_RECOVERY_TIME_STR := (TB5.MOD_RECOVERY_TIME * @MODERATE_PROBABILITY_STR) )
					, TB1.EXTENSIVE_RECOVERY_TIME_STR = ( @EXTENSIVE_RECOVERY_TIME_STR := (TB5.EXT_RECOVERY_TIME * @EXTENSIVE_PROBABILITY_STR) )
					, TB1.COMPLETE_RECOVERY_TIME_STR = ( @COMPLETE_RECOVERY_TIME_STR := (TB5.CMP_RECOVERY_TIME * @COMPLETE_PROBABILITY_STR) )
					
					, TB1.ESTIMATE_RECOVERY_TIME = ( @ESTIMATE_RECOVERY_TIME := (@SLIGHT_RECOVERY_TIME_STR+@MODERATE_RECOVERY_TIME_STR+@EXTENSIVE_RECOVERY_TIME_STR+@COMPLETE_RECOVERY_TIME_STR) )
				WHERE
					TB1.FINAL_CD is not null AND TB1.CT_LON is not null;
					-- TB1.FINAL_CD is not null AND TB1.CT_LON is not null and seq = 617683; 
					
				COMMIT;
				
				UPDATE earthquake_assets_analysis SET STATE='C' , END_DT = NOW() WHERE SEQ = @SEQ;
				COMMIT;
			
			END IF;
							
		END IF;

	END