
subsidence.scenario <- 0.002 #2mm/yr  susbidence, plus GIA included in projections
subsidence.GIA <- 0.0017 #for the reconstructions
   
srocc.proj <- read.table("slr_guadeloupe_RCP85_SROCC_noMIROC.txt")
colnames(srocc.proj) <- c("date","liklow","med","likhigh")
rownames(srocc.proj)  <- 2007:2100



highend.scenar <- read.table("slr_guadeloupe_RCP85_highend_noMIROC.txt")
rownames(highend.scenar)  <- 2007:2100

reconstruct.meyss <- t(read.table("Sea.Level.Guadeloupe.reconstruction.txt"))
reconstruct.meyss[,2:4] <- reconstruct.meyss[,2:4]/1000
                # note: mean(reconstruct.meyss[37:56,2]) vaut quasiment 0

#sea level time series avec prise en compte subsidence locale 
srocc.proj.subs <- srocc.proj
srocc.proj.subs[,2:4] <- srocc.proj.subs[,2:4]+((2007:2100)-1995)*subsidence.scenario
highend.scenar.subs <- highend.scenar
highend.scenar.subs[,2:3] <- highend.scenar[,2:3]+((2007:2100)-1995)*subsidence.scenario

reconstruct.meyss[,2:4] <- reconstruct.meyss[,2:4]+((1950:2009)-1995)*subsidence.GIA
reconstruct.meyss.subs <- reconstruct.meyss
reconstruct.meyss.subs[,2:4] <- reconstruct.meyss[,2:4]+((1950:2009)-1995)*subsidence.scenario

x11(14,7)
par(mfrow=c(1,2))
 plot(srocc.proj[,"date"],srocc.proj[,"med"],"l", xlab = "year", ylab = "Regional sea-level rise in Guadeloupe (m)",xlim=c(1950,2100),ylim=c(-0.25,2.3),col= "red",xaxs = "i", yaxs ="i", main = "A. Vertical ground motions due to GIA")
 polygon(c(srocc.proj[,"date"],rev(srocc.proj[,"date"])),c(srocc.proj[,"liklow"],rev(srocc.proj[,"likhigh"])),col="indianred1",border = NA)
 lines(srocc.proj[,"date"],srocc.proj[,"likhigh"], col = "red")
 lines(srocc.proj[,"date"],srocc.proj[,"liklow"], col = "red")
 lines(srocc.proj[,"date"],srocc.proj[,"med"], col = "red",lwd=2)
 
 lines(srocc.proj[,"date"],highend.scenar[,2], col = "red",lty ="longdash")

 lines(reconstruct.meyss[,1],reconstruct.meyss[,2], col = "gray20") 
 lines(reconstruct.meyss[,1],reconstruct.meyss[,3], col = "green4")
 lines(reconstruct.meyss[,1],reconstruct.meyss[,4], col = "lightgoldenrod4")
 
 legend("topleft",legend=c("Reconstruction: altimetry","Reconstruction: Soda","Reconstruction: Drakkar","Projection: SROCC - median","Projection: SROCC - likely range","High-end scenario"),col=c("gray20","green4","lightgoldenrod4","red","indianred1","red"), lty = c(1,1,1,1,1,2),lwd=c(1,1,1,2,15,1),cex=0.9,bty = "n")

  plot(srocc.proj[,"date"],srocc.proj.subs[,"med"],"l", xlab = "year", ylab = "Regional sea-level rise in Guadeloupe (m)",xlim=c(1950,2100),ylim=c(-0.25,2.3),col= "red",xaxs = "i", yaxs ="i", main = "B. Vertical ground motions due to GIA \n superimposed to a 2mm/year regional subsidence")
  polygon(c(srocc.proj.subs[,"date"],rev(srocc.proj[,"date"])),c(srocc.proj.subs[,"liklow"],rev(srocc.proj.subs[,"likhigh"])),col="indianred1",border = NA)
 lines(srocc.proj[,"date"],srocc.proj.subs[,"likhigh"], col = "red")
 lines(srocc.proj[,"date"],srocc.proj.subs[,"liklow"], col = "red")
 lines(srocc.proj[,"date"],srocc.proj.subs[,"med"], col = "red",lwd=2)
 
 lines(srocc.proj[,"date"],highend.scenar.subs[,2], col = "red",lty ="longdash")

 lines(reconstruct.meyss[,1],reconstruct.meyss.subs[,2], col = "gray20") 
 lines(reconstruct.meyss[,1],reconstruct.meyss.subs[,3], col = "green4")
 lines(reconstruct.meyss[,1],reconstruct.meyss.subs[,4], col = "lightgoldenrod4")

dev.print(jpeg,filename="Fig_3.jpg",quality=100,units="px",width=3500,res=300) 



 #Load distribution of tidal maxima


library("R.matlab")

histo.maree <- readMat("histo.mat")

plot(histo.maree$centers2,histo.maree$counts2, "l", xlab = "Highest daily water level (annual mean) \n (in m with respect to IGN88 reference)", ylab = "Number of counts")

histo.maree.cdf.last <- 0
histo.maree.cdf <- c()
for (ii in 1:length(histo.maree$counts2))  {
    histo.maree.cdf <- c(histo.maree.cdf,histo.maree$counts2[ii]/sum(histo.maree$counts2)+histo.maree.cdf.last) 
    histo.maree.cdf.last <-  histo.maree.cdf[ii]
}
x11(5,4)
plot(histo.maree$centers2,1-histo.maree.cdf, "l", xlab = "Highest daily water level (annual mean) \n (in m with respect to IGN88 reference)", ylab = "Yearly probability of exceedance")



#returns number of days of nuisance flooding with slr.x sea level rise

#reference = local geodetic reference framework IGN88
calcule.nb.jours <- function(SLR.l,Seuil.l,histo.maree.i = histo.maree) {
     nb.jours <- histo.maree.i$counts2*365.25/sum(histo.maree.i$counts2)
     index.jours <- which(histo.maree.i$centers2+SLR.l>Seuil.l)
     nb.jours.SLR <- sum(nb.jours[index.jours])
     return(nb.jours.SLR)
}


#Nbre de jours par an avec un dpassement de seuil 0.5 pour le niveau de la mer actuel
calcule.nb.jours(0,0.5)

  slr <- seq(-0.2,0.5,0.01)
  
  nb.jours.depassement <- c()
  for (i in slr)  {
      nb.jours.depassement <- c(nb.jours.depassement,calcule.nb.jours(i,0.5))
  }
  x11()
  plot(slr,nb.jours.depassement,"l", xlab = "sea level changes", ylab = "Nuisance flooding (days/year) ")
  
  



 x11(18,21)
#par(mfrow=c(3,2),mar=c(5.1,5,2.1,2.1),oma = c(0.2,0.5,0.2,0.2))
par(mfrow=c(3,2),mar=c(2.1,4,2.1,0.5),oma = c(0.2,2,0.2,0.5))
threshold <- 0.8
 plot(srocc.proj[,"date"],sapply(srocc.proj[,"med"],calcule.nb.jours,threshold),"l", xlab = " ", ylab = "Number of flood days per year",xlim=c(2000,2100),ylim=c(0,360),col= "red",xaxs = "i", yaxs ="i", main = "A.1 Vertical ground motions: GIA only")
 mtext("High-vulnerability sites (0.8m IGN88) \n ",side = 2, outer = F, line = 3, font = 2, cex = 0.8)
   legend("topleft",title = "Background projections:",legend=c("SROCC - median","SROCC - likely range","High-end scenario"),col=c("red","indianred1","red"), lty = c(1,1,2),lwd=c(2,15,1),cex=0.9,bty = "n")
 polygon(c(srocc.proj[,"date"],rev(srocc.proj[,"date"])),c(sapply(srocc.proj[,"liklow"],calcule.nb.jours,threshold),rev(sapply(srocc.proj[,"likhigh"],calcule.nb.jours,threshold))),col="indianred1",border = NA)
 lines(srocc.proj[,"date"],sapply(srocc.proj[,"likhigh"],calcule.nb.jours,threshold), col = "red")
 lines(srocc.proj[,"date"],sapply(srocc.proj[,"liklow"],calcule.nb.jours,threshold), col = "red")
 lines(srocc.proj[,"date"],sapply(srocc.proj[,"med"],calcule.nb.jours,threshold), col = "red",lwd=1)
 
 lines(srocc.proj[,"date"],sapply(highend.scenar[,2],calcule.nb.jours,threshold), col = "red",lty ="longdash")

 lines(reconstruct.meyss[,1],sapply(reconstruct.meyss[,2],calcule.nb.jours,threshold), col = "gray20") 
 lines(reconstruct.meyss[,1],sapply(reconstruct.meyss[,3],calcule.nb.jours,threshold), col = "green4")
 lines(reconstruct.meyss[,1],sapply(reconstruct.meyss[,4],calcule.nb.jours,threshold), col = "lightgoldenrod4")
box()
 
 plot(srocc.proj[,"date"],sapply(srocc.proj.subs[,"med"],calcule.nb.jours,threshold),"l", xlab = " ", ylab = " ",xlim=c(2000,2100),ylim=c(0,360),col= "red",xaxs = "i", yaxs ="i", main = "B.1 GIA and subsidence of 2mm/year")
 polygon(c(srocc.proj[,"date"],rev(srocc.proj[,"date"])),c(sapply(srocc.proj.subs[,"liklow"],calcule.nb.jours,threshold),rev(sapply(srocc.proj.subs[,"likhigh"],calcule.nb.jours,threshold))),col="indianred1",border = NA)
 lines(srocc.proj[,"date"],sapply(srocc.proj.subs[,"likhigh"],calcule.nb.jours,threshold), col = "red")
 lines(srocc.proj[,"date"],sapply(srocc.proj.subs[,"liklow"],calcule.nb.jours,threshold), col = "red")
 lines(srocc.proj[,"date"],sapply(srocc.proj.subs[,"med"],calcule.nb.jours,threshold), col = "red",lwd=1)
 
 lines(srocc.proj[,"date"],sapply(highend.scenar.subs[,2],calcule.nb.jours,threshold), col = "red",lty ="longdash")

 lines(reconstruct.meyss[,1],sapply(reconstruct.meyss.subs[,2],calcule.nb.jours,threshold), col = "gray20") 
 lines(reconstruct.meyss[,1],sapply(reconstruct.meyss.subs[,3],calcule.nb.jours,threshold), col = "green4")
 lines(reconstruct.meyss[,1],sapply(reconstruct.meyss.subs[,4],calcule.nb.jours,threshold), col = "lightgoldenrod4")

 box()

threshold <- 1
 plot(srocc.proj[,"date"],sapply(srocc.proj[,"med"],calcule.nb.jours,threshold),"l", xlab = "year", ylab = "Number of flood days per year",xlim=c(2000,2100),ylim=c(0,360),col= "red",xaxs = "i", yaxs ="i", main = "A.2 Vertical ground motions: GIA only")
  mtext("Medium-vulnerability sites (1m IGN88) \n ",side = 2, outer = F, line = 3, font = 2, cex = 0.8)
 polygon(c(srocc.proj[,"date"],rev(srocc.proj[,"date"])),c(sapply(srocc.proj[,"liklow"],calcule.nb.jours,threshold),rev(sapply(srocc.proj[,"likhigh"],calcule.nb.jours,threshold))),col="indianred1",border = NA)
 lines(srocc.proj[,"date"],sapply(srocc.proj[,"likhigh"],calcule.nb.jours,threshold), col = "red")
 lines(srocc.proj[,"date"],sapply(srocc.proj[,"liklow"],calcule.nb.jours,threshold), col = "red")
 lines(srocc.proj[,"date"],sapply(srocc.proj[,"med"],calcule.nb.jours,threshold), col = "red",lwd=1)
 
 lines(srocc.proj[,"date"],sapply(highend.scenar[,2],calcule.nb.jours,threshold), col = "red",lty ="longdash")

 lines(reconstruct.meyss[,1],sapply(reconstruct.meyss[,2],calcule.nb.jours,threshold), col = "gray20") 
 lines(reconstruct.meyss[,1],sapply(reconstruct.meyss[,3],calcule.nb.jours,threshold), col = "green4")
 lines(reconstruct.meyss[,1],sapply(reconstruct.meyss[,4],calcule.nb.jours,threshold), col = "lightgoldenrod4")
 box()
 
 plot(srocc.proj[,"date"],sapply(srocc.proj.subs[,"med"],calcule.nb.jours,threshold),"l", xlab = "year", ylab = " ",xlim=c(2000,2100),ylim=c(0,360),col= "red",xaxs = "i", yaxs ="i", main = "B.2 GIA and subsidence of 2mm/year")
 polygon(c(srocc.proj[,"date"],rev(srocc.proj[,"date"])),c(sapply(srocc.proj.subs[,"liklow"],calcule.nb.jours,threshold),rev(sapply(srocc.proj.subs[,"likhigh"],calcule.nb.jours,threshold))),col="indianred1",border = NA)
 lines(srocc.proj[,"date"],sapply(srocc.proj.subs[,"likhigh"],calcule.nb.jours,threshold), col = "red")
 lines(srocc.proj[,"date"],sapply(srocc.proj.subs[,"liklow"],calcule.nb.jours,threshold), col = "red")
 lines(srocc.proj[,"date"],sapply(srocc.proj.subs[,"med"],calcule.nb.jours,threshold), col = "red",lwd=1)
 
 lines(srocc.proj[,"date"],sapply(highend.scenar.subs[,2],calcule.nb.jours,threshold), col = "red",lty ="longdash")

 lines(reconstruct.meyss[,1],sapply(reconstruct.meyss.subs[,2],calcule.nb.jours,threshold), col = "gray20") 
 lines(reconstruct.meyss[,1],sapply(reconstruct.meyss.subs[,3],calcule.nb.jours,threshold), col = "green4")
 lines(reconstruct.meyss[,1],sapply(reconstruct.meyss.subs[,4],calcule.nb.jours,threshold), col = "lightgoldenrod4")
  box()
  
 threshold <- 2
 plot(srocc.proj[,"date"],sapply(srocc.proj[,"med"],calcule.nb.jours,threshold),"l", xlab = "year", ylab = "Chronic flooding at low-vulnerability sites (2m IGN88) \n number of days per year",xlim=c(2000,2100),ylim=c(0,360),col= "red",xaxs = "i", yaxs ="i", main = "A.3 Vertical ground motions: GIA only")
  mtext("Low-vulnerability sites (2m IGN88) \n ",side = 2, outer = F, line = 3, font = 2, cex = 0.8)
 polygon(c(srocc.proj[,"date"],rev(srocc.proj[,"date"])),c(sapply(srocc.proj[,"liklow"],calcule.nb.jours,threshold),rev(sapply(srocc.proj[,"likhigh"],calcule.nb.jours,threshold))),col="indianred1",border = NA)
 lines(srocc.proj[,"date"],sapply(srocc.proj[,"likhigh"],calcule.nb.jours,threshold), col = "red")
 lines(srocc.proj[,"date"],sapply(srocc.proj[,"liklow"],calcule.nb.jours,threshold), col = "red")
 lines(srocc.proj[,"date"],sapply(srocc.proj[,"med"],calcule.nb.jours,threshold), col = "red",lwd=1)
 
 lines(srocc.proj[,"date"],sapply(highend.scenar[,2],calcule.nb.jours,threshold), col = "red",lty ="longdash")

 lines(reconstruct.meyss[,1],sapply(reconstruct.meyss[,2],calcule.nb.jours,threshold), col = "gray20") 
 lines(reconstruct.meyss[,1],sapply(reconstruct.meyss[,3],calcule.nb.jours,threshold), col = "green4")
 lines(reconstruct.meyss[,1],sapply(reconstruct.meyss[,4],calcule.nb.jours,threshold), col = "lightgoldenrod4")
 box()
 
 plot(srocc.proj[,"date"],sapply(srocc.proj.subs[,"med"],calcule.nb.jours,threshold),"l", xlab = "year", ylab = " ",xlim=c(2000,2100),ylim=c(0,360),col= "red",xaxs = "i", yaxs ="i", main = "B.3 GIA and subsidence of 2mm/year")
 polygon(c(srocc.proj[,"date"],rev(srocc.proj[,"date"])),c(sapply(srocc.proj.subs[,"liklow"],calcule.nb.jours,threshold),rev(sapply(srocc.proj.subs[,"likhigh"],calcule.nb.jours,threshold))),col="indianred1",border = NA)
 lines(srocc.proj[,"date"],sapply(srocc.proj.subs[,"likhigh"],calcule.nb.jours,threshold), col = "red")
 lines(srocc.proj[,"date"],sapply(srocc.proj.subs[,"liklow"],calcule.nb.jours,threshold), col = "red")
 lines(srocc.proj[,"date"],sapply(srocc.proj.subs[,"med"],calcule.nb.jours,threshold), col = "red",lwd=1)
 
 lines(srocc.proj[,"date"],sapply(highend.scenar.subs[,2],calcule.nb.jours,threshold), col = "red",lty ="longdash")

 lines(reconstruct.meyss[,1],sapply(reconstruct.meyss.subs[,2],calcule.nb.jours,threshold), col = "gray20") 
 lines(reconstruct.meyss[,1],sapply(reconstruct.meyss.subs[,3],calcule.nb.jours,threshold), col = "green4")
 lines(reconstruct.meyss[,1],sapply(reconstruct.meyss.subs[,4],calcule.nb.jours,threshold), col = "lightgoldenrod4")
 box()
 
dev.print(jpeg,filename="Fig_7.jpg",quality=100,units="px",width=2500,res=300) 




 x11(18,7)
#par(mfrow=c(3,2),mar=c(5.1,5,2.1,2.1),oma = c(0.2,0.5,0.2,0.2))
par(mfrow=c(1,2),mar=c(2.1,4,2.1,0.5),oma = c(0.2,2,0.2,0.5))
threshold <- 0.5
 plot(srocc.proj[,"date"],sapply(srocc.proj[,"med"],calcule.nb.jours,threshold),"l", xlab = " ", ylab = "Number of flood days per year",xlim=c(1950,2100),ylim=c(0,360),col= "red",xaxs = "i", yaxs ="i", main = "A. Vertical ground motions: GIA only")
 mtext("Coastal sites at 0.5m altitude (reference: IGN88) \n ",side = 2, outer = F, line = 3, font = 2, cex = 1.2)
 
  legend("topleft",title = "Background sea level information:",legend=c("Reconstruction: altimetry","Reconstruction: Soda","Reconstruction: Drakkar","Projection: SROCC - median","Projection: SROCC - likely range","High-end scenario"),col=c("gray20","green4","lightgoldenrod4","red","indianred1","red"), lty = c(1,1,1,1,1,2),lwd=c(1,1,1,2,15,1),cex=0.9,bty = "n")
 
 polygon(c(srocc.proj[,"date"],rev(srocc.proj[,"date"])),c(sapply(srocc.proj[,"liklow"],calcule.nb.jours,threshold),rev(sapply(srocc.proj[,"likhigh"],calcule.nb.jours,threshold))),col="indianred1",border = NA)
 lines(srocc.proj[,"date"],sapply(srocc.proj[,"likhigh"],calcule.nb.jours,threshold), col = "red")
 lines(srocc.proj[,"date"],sapply(srocc.proj[,"liklow"],calcule.nb.jours,threshold), col = "red")
 lines(srocc.proj[,"date"],sapply(srocc.proj[,"med"],calcule.nb.jours,threshold), col = "red",lwd=1)
 
 lines(srocc.proj[,"date"],sapply(highend.scenar[,2],calcule.nb.jours,threshold), col = "red",lty ="longdash")

 lines(reconstruct.meyss[,1],sapply(reconstruct.meyss[,2],calcule.nb.jours,threshold), col = "gray20") 
 lines(reconstruct.meyss[,1],sapply(reconstruct.meyss[,3],calcule.nb.jours,threshold), col = "green4")
 lines(reconstruct.meyss[,1],sapply(reconstruct.meyss[,4],calcule.nb.jours,threshold), col = "lightgoldenrod4")
box()
 
 plot(srocc.proj[,"date"],sapply(srocc.proj.subs[,"med"],calcule.nb.jours,threshold),"l", xlab = " ", ylab = " ",xlim=c(1950,2100),ylim=c(0,360),col= "red",xaxs = "i", yaxs ="i", main = "B. GIA and subsidence of 2mm/year")
 polygon(c(srocc.proj[,"date"],rev(srocc.proj[,"date"])),c(sapply(srocc.proj.subs[,"liklow"],calcule.nb.jours,threshold),rev(sapply(srocc.proj.subs[,"likhigh"],calcule.nb.jours,threshold))),col="indianred1",border = NA)
 lines(srocc.proj[,"date"],sapply(srocc.proj.subs[,"likhigh"],calcule.nb.jours,threshold), col = "red")
 lines(srocc.proj[,"date"],sapply(srocc.proj.subs[,"liklow"],calcule.nb.jours,threshold), col = "red")
 lines(srocc.proj[,"date"],sapply(srocc.proj.subs[,"med"],calcule.nb.jours,threshold), col = "red",lwd=1)
 
 lines(srocc.proj[,"date"],sapply(highend.scenar.subs[,2],calcule.nb.jours,threshold), col = "red",lty ="longdash")

 lines(reconstruct.meyss[,1],sapply(reconstruct.meyss.subs[,2],calcule.nb.jours,threshold), col = "gray20") 
 lines(reconstruct.meyss[,1],sapply(reconstruct.meyss.subs[,3],calcule.nb.jours,threshold), col = "green4")
 lines(reconstruct.meyss[,1],sapply(reconstruct.meyss.subs[,4],calcule.nb.jours,threshold), col = "lightgoldenrod4")

 box()
 
 dev.print(jpeg,filename="Fig_8.jpg",quality=100,units="px",width=3600,res=300)
